%Example: Run a simulation with a default conventional vehicle
clear

%% Create a vehicle configuration, load the mission
% Creating a configuration involves two steps:
%   - Specify each components' name in a vehConf.
%   - Load all the components using createConfiguration. 

% The configuration contains the components names. Start with a default
% configuration and modify its fields if needed. The corresponding
% components must exist in the library folder.
conf = vehConf('bev');

% Replace some components
conf.em_name = "ldv125";

% Create the vehicle data using createConfiguration
veh = createVehicle(conf);

% Resize some components
veh.batt = scaleBatt(veh.batt, 20);
veh.em = scaleEMachine(veh.em, 40);

% Select the mission. This must be an existing .mat file in the library
mission_name = "wltc3";

%% Run simulation
% Run a simulation specifying
% - the initial SOC,
% - a simulation timestep
% - turn off mission adaptation

[results, veh, prof, info] = vehicleSim(veh, mission_name, ...
    'SOC_initial', 0.6, 'timestep', 0.5, 'driverModel', false);

% Plot
mainProfiles(prof, veh, ["vehSpd", "emTrq", "battSOC", "unfeas"]);

%% Turn the driver model and re-run
[results, veh, prof, info] = vehicleSim(veh, mission_name, ...
    'SOC_initial', 0.6, 'timestep', 0.5, 'driverModel', true);

% Plot profiles
mainProfiles(prof, veh, ["refSpd", "vehSpd", "emTrq", "battSOC", "unfeas"]);

% Plot e-machine operating points
emMapOperation(veh.em, prof, 'eff')